
/**
 *    infoMenu and sliderMenu Menu 
 */
(function($) { 
   
	// menuindicator instead of icon
	var menu2Open  =  ">";   // &#187;		
	var menu2Close =  "<";   // &#171;
	
   var indent = 10;
   
   // for slider dimension, see also  CSS #sliderMenu 
   var sliderWidth = 400;
   var sliderTextWidth = 280;
   
   var sliderFontHeight = 24;     
      
   var navigatorLanguage = this.navigator.language;


   $(document).ready(function() {
      
      infoSupport.buildInfoMenu();       
      infoSupport.buildSliderMenu();     
        
      var href = location.href;         
      var i = location.href.indexOf("infoPages") + 10;         
      infoSupport.switchLanguage (location.href.substring(i, i + 2)); 
      
      // open navigation menu
      var itemMenu = location.href.substring(i)
               .replace(new RegExp(/.html/g),"")
               .replace(new RegExp(/\//g),"")
               .replace(new RegExp(/#/g),""); 
      if ($('#' + itemMenu).length != 0) {            
         $('#' + itemMenu)[0].parentNode.attributes['style'].nodeValue = "";
      }             

      // sliderMenu: goto selected 'id' and close sliderMenu  
         /******************************************
         * Based on:
         * Website: http://www.developersnippets.com
         * 
         * Slider Control 
         ******************************************/ 
      $("a.anchorLink").click(function () {  
         elementClick = $(this).attr("href");
         destination = $(elementClick).offset().top;
         $("html:not(:animated),body:not(:animated)").animate({ scrollTop: destination}, 1000 );
         // after scrolling to selected 'id', close sliderMenu
         setTimeout( infoSupport.closeSliderMenu, 1000 );       
         return false;
      })
   
      // Mouse Enter Event (that is mouseover event)
      // open the sliderMenu, will be closed with selecting 'id' or 
      // select position out side of sliderMenu
      $(".toggleBtn").bind("mouseenter",function(){
            if($("#sliderMenu").hasClass('closed')){
               $("#sliderMenu").animate({left:0}, 500, function(){
                  $(this).removeClass('closed').addClass('opened');
               });
            }//if close         
      });//toggleBtn click close
   });//                    ^^^^^^^^^^^^^^^^^^^ $(document).ready(function() ^^^
   
   
   $(document).click(function(event) { 

      // skip if "INPUT" ... tribute to Goggle Search which throws error with 
      //  'event.originalTarget.className'
      if (event.originalEvent.explicitOriginalTarget.nodeName == "INPUT") return;

      // *** subMenu **************
      if (event.target.attributes["submenu"] != null) {
         infoSupport.subMenu (event.target.id)       
      }

      var clickOrg = event.target.className;

      // *** switch language **************
      if (clickOrg == 'languageSwitch') {        
         infoSupport.switchLanguage (event.target.lang);
      }; 
   
	   setTimeout(infoSupport.closeSliderMenu, 1000 );       		
   });   //                ^^^^^^^^^^^^^^  $(document).click(function(event) ^^^




	/**
	 *   Support functions for 'infoMenu' and 'sliderMenu' 
	 */
	var infoSupport = {

      subMenu :    function  (menuItem) { 
      // 'menuItemText' is used to switch the menu indicator      +++todo    change the menuindicator to use icon
         var menuItemText = $('div#' + menuItem)[0].textContent; 
         
         // menuItem + 'subMenu' is build with header id  
         var ulSlider = $('div#' + (menuItem + 'subMenu') );   
         
         if (ulSlider.length != 0) { 
            if ((ulSlider)[0].attributes["style"].nodeValue == "display: none;") {
               $('div#' + menuItem)[0].textContent = menu2Close + menuItemText.substr(1);       
               $('#' + menuItem + 'subMenu').fadeIn('slow'); 
            } else {
               $('div#' + menuItem)[0].textContent = menu2Open + menuItemText.substr(1);
               $('#' + menuItem + 'subMenu').fadeOut('slow');   
            };
         }
      },                           // ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^Slider Menu ^^^

      closeSliderMenu: function () {
         $("#sliderMenu").animate({left:-sliderWidth}, 500, function(){
            $(this).removeClass('opened').addClass('closed');
         });
      },

      /**
       *     build  'sliderMenu'  from 'sectionSetup' array 
       */
      buildSliderMenu : function() {

         var sections = $('.infoSection');
         var sliderMenuHeight = (sections.length + 3) * sliderFontHeight;

         // remove the sliderMenu to rebuild with new section details 
         $("#sliderMenu").remove();
            
         $('#infoSection').append(
            '<div id="sliderMenu" class="closed" style="height: ' + sliderMenuHeight + 'px">'
         );
         $('#sliderMenu').append(
             '<div id="infoMenuTitle"'
            +' class="sliderMenuContent">'
            +' <strong>Quick Links</strong> &nbsp; &nbsp; &nbsp; &nbsp; (Select section or click outside of menu to close slider.)'
         );
         $('#infoMenuTitle').append(
            '<ol id="infoMenuList">'
         );
         $('#infoMenuTitle').append(
             '<div style="top:100px; right: -42px;"'
            +' class="toggleBtn"'
            +' id="toggleLink">'
         );
         
         // .. now insert actual section details 
         for (var i = sections.length - 1; i > -1; i--) {  
            var  iTitle = "";
            if (sections[i].title == "") {
               iTitle = sections[i].textContent;
            } else {
                iTitle = sections[i].title;
            }
            
            $("#infoMenuList").prepend(
               '<li class="infoMenuItem" '
               + ' id="' + "x" + sections[i].id +'" >'
               + '<a class="anchorLink"'
               + ' title="' + iTitle +'"'
               + ' href="#' + sections[i].id + '">' 
               + sections[i].textContent
               + '</a></li>'); 
            
            // limit the 'text' so it fit to one row on the slider   
            var xx = $("#" + "x" + sections[i].id); 
            
            var aWidth =  xx[0].children[0].offsetWidth;
            var aText =  xx[0].children[0].textContent;
            
            if (aWidth > sliderTextWidth) {
               var aTextTrail =  aText.substr(aText.length-5, 5);  
               var aText =  aText.substr(0, aText.length - 10);  
               
               while (aWidth > sliderTextWidth) {
                  var aText = aText.substr(0, aText.length - 1);
                  xx[0].children[0].textContent = aText + " ... " + aTextTrail;
                  var aWidth =  xx[0].children[0].offsetWidth;
               }
            }
         }
         // .. insert the 'Top' navigation item
         $("#infoMenuList").prepend(
            '<li class="infoMenuItem">'
            + '<a class="anchorLink" href="#"> ^ &nbsp;&nbsp; Top' 
            + '</a></li>');
      },  //                            ^^^^^^^^^^^^^^^^^^^^^^^^^ sliderMenu ^^^      



      //************************************************************************

            
      switchLanguage: function (language) {
         for (var n = 0; n < sectionSetup.length; n++) {
            document.getElementById(sectionSetup[n][0]).style.display = 'none';
         }
         
         var cLanguage = document.getElementById('languageIndex').lang;
                  
         if ((language == "") || (language == null)) {
           language = cLanguage;
           if ((cLanguage == "") || (cLanguage == null)) {
              language = navigatorLanguage;
           }
         }             
         language = language.substring(0,2);
         var iLang = this.getLanguage (language);  // get the index of used language

         document.getElementById(language).style.display = 'block';
         document.getElementById('languageIndex').lang = language;
         
         // text & title the gSearch 
         document.getElementById(sectionSetup [iLang][2][0]).textContent = sectionSetup [iLang][2][1];
         document.getElementById(sectionSetup [iLang][2][0]).title = sectionSetup [iLang][2][2];

      },  //         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ switchLanguage (language) ^^^ 


 
      /**
       *    build "navigation" menu from 'sectionSetup' array in 'infoSections.js'     
       */
      buildInfoMenu : function () {
         
         $("#languageHeader").empty();
                  
         for (var n = 0; n < sectionSetup.length; n++) {         
            var title = this.getElement (n /*language*/, 'menu' /*cSection*/, 1 /*cElement*/);
            var ttt   = this.getElement (n /*language*/, 'menu' /*cSection*/, 2 /*cElement*/);
   
            $("#languageHeader").append
                 ("<description class='languageSwitch' "
                  + " title='" + ttt + "' lang='" + sectionSetup[n][0] +"'>"
                  + title + "</description>");
         }

         $("#languageIndex").empty();
         this.searchGoogle('gSearch');     // first 'item' in "navigation" menu      

         // section list using 'sectionSetup' for all 'language's 
         for (var n = 0; n < sectionSetup.length; n++) {  
        
            var language = sectionSetup[n][0];
            $("#languageIndex").append
               ('<ul id="' + language + '" class="menu" style="display:none">');                                   

            var iLang = this.getLanguage(language);     
            $("#" + language).empty();

            var cMenu = language;              
            var mClass = 0;               
            // start with entry #3 -- skip language, menu, gSearch
            for (var m = 3; m < sectionSetup [iLang].length; m++) {            	           
            	 mClass = this.menuMain (sectionSetup [iLang][m], '#' + cMenu, language, mClass);
            }
         }   
      },  
      

	       
      menuMain : function (menuString, cMenu, language, mClass) {
	      
	      switch (menuString[0]) {  // switch on special controls
	         case "br": 
	            $(cMenu).append ('<br>');
	            break;                     
	         case "hr": 
	            $(cMenu).append 
	              ('<hr'
                  + ' style="margin-left: ' + (indent * mClass) + 'px"'       
	               + '>');
	            break;              
	
	         default:                         
	            if (menuString.length <= 3) {
	               this.menuLink(menuString, cMenu, language, mClass);
	            } else {
                  this.menuHeader(menuString, cMenu, language, mClass);
	            } 
	      }
         return mClass;
      },
      
      menuLink : function (menuString, cMenu, language, mClass) {
         var item  = menuString[0];
         var title = menuString[1];
         var ttt   = menuString[2];

         var aLink = this.linkAddress(item, title, ttt, language);
         
         $(cMenu).append
               ('<div'
               + ' id="' + language  + item.replace(new RegExp(/#/g),"") + '"'
               + ' class="infoMenu' + ((mClass == 0) ? "" : mClass) +'"'
               + ' style="margin-left: ' + (indent * mClass) + 'px"'       
               + '>' + aLink + '</div>');                     
      },
      
      menuHeader : function (menuString, cMenu, language, mClass) {
         var iClass = mClass;   // remember mClass to be able to reset on leave

         var item  = menuString[0];
         var title = menuString[1];
         var ttt   = menuString[2];
         var iOpen = false;

         if (item.charAt(0) == '<') {
         	iOpen = true;
         	item = item.substr(1);
         }
         var mClass = this.menuHeaderLine(cMenu, item, title, ttt, mClass, iOpen) + 1;     

         var subMenuArray = menuString[3];
         var nSub = subMenuArray.length;
         
         for (var s = 0; s < subMenuArray.length; s++) {       	
         	mClass = this.menuMain (subMenuArray[s], '#' + item + 'subMenu', language, mClass, iOpen );                            
         }
         return iClass;
      },

      menuHeaderLine : function (cMenu, item, title, ttt, mClass, itemOpen) {
         var itemOpenStr = ' style="display:block';
         var menuIcon = menu2Close;
         
         if (itemOpen == false) { 
         	itemOpenStr = ' style="display:none';
         	menuIcon = menu2Open; 
         }
         
         // <p id="item" subMenu title="ttt"># title/p> 
         $(cMenu).append
              ('<div id="'+ item + '"'
               + ' class="infoMenu' + ((mClass == 0) ? "" : mClass) +'"'
               + ' style="margin-left: ' + (indent * mClass) + 'px"'

               + ' subMenu title="' + ttt + '">' + menuIcon + ' ' + title 
               + '</div>');       

         $(cMenu).append 
               ('<div'
               + ' style="margin-left: ' + (indent * (mClass+1)) + 'px"'               
               + ' class="brief">' + ttt 
               + '</div>');
               
         $(cMenu).append
               ('<div id="' + item + 'subMenu"'
               + itemOpenStr
               + ' "></div>');

         return mClass;
      },
      
      linkAddress : function (item, title, ttt, language) { // add language and check for .html 
      
         if (item.indexOf('http') == 0) {  // this is absolute link
            addr = item;            
         } else {
                    
            if (item.indexOf("#") > -1) {
               var i = item.indexOf("#");
               item = item.substr(0,i) + '.html' + item.substr(i);
               var addr =  "../" + language + "/" + item;
            } else {
               var addr =  "../" + language + "/" + item + ".html";
            }
         }
         addr = ("<a href='" + addr + "' title='" + ttt + "'>" 
                             + title + "</a>");
         return addr;                   
      },                             // ^^^^^^^^^^^^^^^^ build infoMenu subs ^^^
             
      /**
       *   get array# from 'language' string
       *   @return  index of language in 'infoSection' array
       *   @default 0
       */
      getLanguage:  function (language) {
         for (var i = 0; i < sectionSetup.length; i++) {
            if (sectionSetup[i][0] == language) return i;
         }
         return 0; // use first as default   
      },
      
      /**
       *   get string from 'infoSections.js' array for given element (like 'language' and 'menu')
       *   @return  string
       *   @default empty string
       */
      getElement: function (language, item, n) {
         for (var i = 1; i < sectionSetup[language].length; i++) {
            if (sectionSetup[language][i][0] == item) return sectionSetup[language][i][n];      
         }
         return ""; // return empty string  
      },     
            
      
      /**
       *    "Google Search" menu item can be opened/closed with 
       *       javascript:sliderMenu(\'searchSlider\'
       */ 
      searchGoogle : function (menuName) {    // menuName = gSearch

         // <h3 id="menuName" subMenu title="ttt"> title</h3>         
         var searching  = '<!-- subMenu -->'   
                        + '<h3 id="' +  menuName + '"  '
                        + '" title="gSearch Titel">##' + menuName +  '##</h3>'; 
                                           
             searching += '<ul id="' + (menuName + 'subMenu') + '" >';
                                                    
             searching += '  <form action="http://reminderfox.mozdev.org/searchresults.html" id="cse-search-box">';
             searching += '    <div>';
             searching += '       <input type="hidden" name="cx" value="partner-pub-2700097556160626:fkn47y67z18" />';
             searching += '       <input type="hidden" name="cof" value="FORID:9" />';
             searching += '       <input type="hidden" name="ie" value="ISO-8859-1" />';
             searching += '       <input type="text" name="q" size="18" />';
             searching += '       <input type="submit" name="sa" value="Search" />';
             searching += '    </div>';
             searching += '  </form>';
             searching += '<!-- subMenu --></ul>';
             
             searching += '<script type="text/javascript" '
                        + 'src="http://www.google.com/cse/brand?form=cse-search-box&amp;lang=en">'
                        + '</script>';
             $("#languageIndex").append (searching);
      }          
	};	
})(jQuery);